#ifndef RWCOMMON_H
#define RWCOMMON_H

#include <windows.h>
#include <crtdbg.h>
#include "max.h"
#include <rwcore.h>
#include <rpworld.h>
#include <rtworld.h>
#include <rtimport.h>
#include <rpskin.h>

#define KEYTYPE_ROTATION    1
#define KEYTYPE_TRANSLATION 2
#define KEYTYPE_SCALE       4

typedef struct ANMNodeInfo {
    INode   *node;
    RwBool  *keys;
    RwInt32 tag;    
} ANMInfo;

typedef struct AnimKeyFrameListEntry _AnimKeyFrameListEntry;

struct AnimKeyFrameListEntry
{
    RtQuat q;
    RwV3d t;
    RwReal time;    
    RwUInt32 bone;
    AnimKeyFrameListEntry *next;
};

typedef struct clumpAndFrameTag 
{
    RpClump *clump;
    RwFrame *frame;
    RpAtomic *atomic;
} clumpAndFrame;

class RwLib
{
public:
                RwLib(HWND window, BOOL anim, BOOL skinning, BOOL spline, BOOL morph, BOOL collision, BOOL label, BOOL hanim);
                ~RwLib(void);
    BOOL        Opened(void);

    /* Customisable functions. */
    BOOL        RwLibPreConstructor();
    BOOL        RwLibCustomPlugin();
    BOOL        RwLibPostConstructor();

    BOOL        RwLibPreDeconstructor();
    BOOL        RwLibPostDeconstructor();

private:
    static int  m_instances;
    static BOOL m_opened;
};

RwCamera *CreateCamera(RwInt32 nWidth, RwInt32 nHeight, RwBool bZBuffer);
void DestroyCamera(RwCamera *cpCamera);

#ifdef    __cplusplus
extern "C"
{
#endif                          /* __cplusplus */

extern char         * _rwexpsprintf(const char * format,...);

#ifdef    __cplusplus
}
#endif                          /* __cplusplus */

#define RWEXPMESSAGE(_args)                     \
   OutputDebugString(_rwexpsprintf _args)

#endif /* RWCOMMON_H */
